function [K0,P0,gamma0] = Baseline_controller(A,B,D,Mc,Nc,Cx)

% Note: The gamma values in Table 4.1 are obtained with the settings below:
% Case 1: The optimal gamma 0.54888 is obtained by setting gamma as a decision variable
% Cases 2,3,4,5: The other gamma values are obtained via setting gamma as constant

[n,m] = size(B);
[~,l] = size(D);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
gamma0 = sdpvar(1);
M0 = sdpvar(m,n);
P = sdpvar(n,n);

LMI1 = blkvar();
LMI1(1,1) = (A*P+B*M0)+(A*P+B*M0)';
LMI1(1,2) = D;
LMI1(1,3) = Mc;
LMI1(1,4) = P*Nc';
LMI1(1,5) = P*Cx';

LMI1(2,2) = -gamma0*eye(l);
LMI1(2,3) = zeros(l,n);
LMI1(2,4) = zeros(l,n);
LMI1(2,5) = zeros(l,n);

LMI1(3,3) = -eye(n);
LMI1(3,4) = zeros(n,n);
LMI1(3,5) = zeros(n,n);

LMI1(4,4) = -eye(n);
LMI1(4,5) = zeros(n,n);

LMI1(5,5) = -gamma0*eye(n);

LMI1 = sdpvar(LMI1);


const = [];
objective = 1.0e-3*gamma0;

const = [const, P >= eps*eye(n)];
const = [const, gamma0 >= 0];
const = [const, LMI1 <= -eps*eye(4*n+l)];

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%5
ops = sdpsettings('solver','mosek','verbose','1');
optimize(const,objective,ops);

K0 =  value(M0)*inv(value(P));
gamma0 = value(gamma0);
P0 = value(P);



